
import SwiftUI

struct ContentView: View {
   @State private var message = "Hello, world!"

   var body: some View {
      VStack {
         Text(message)
            .padding()
         Button("Run Task") {
            Task {
               await loadImage(name: "My Image")
            }
         }
      }
   }
   @concurrent
   func loadImage(name: String) async {
      sleep(5)
      Task {
         await MainActor.run {
            message = "\(name)"
         }
      }
   }
}

#Preview {
    ContentView()
}
